﻿using System.Collections.Generic;
using System.Windows.Controls;

namespace AvWorksBrowser
{
    public partial class MainPage : UserControl
    {
        public MainPage()
        {
            InitializeComponent();

            CategoryViewModel.GetCategories(delegate(IList<CategoryViewModel> categoryViewModels)
            {
                // Listing 20-29. Dostarczanie elementów do wyświetlenia na liście.
                categoryList.ItemsSource = categoryViewModels;
            });
        }

        // Listing 20-30. Wczytywanie produktów z wybranej kategorii.
        private void categoryList_SelectionChanged(object sender,
        SelectionChangedEventArgs e)
        {
            CategoryViewModel currentCategory =
            categoryList.SelectedItem as CategoryViewModel;
            if (currentCategory == null)
            {
                productList.ItemsSource = null;
            }
            else
            {
                productList.ItemsSource = currentCategory.Products;
            }
        }
    }
}
